<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');
    protected $fillable = array('email', 'first_name', 'last_name', 'nick_name', 'active', 'password_changed_at');
    protected $hidden = array('password');

    public function priceAlerts()
    {
        return $this->hasOne('PriceAlert');
    }

}